#include "Tktds8k.h"
#include <formatio.h>
#include <ansi_c.h>
#include <cvirte.h>		
#include <userint.h>
#include "Demo1.h"

#define TRUE 1
#define FALSE 0

static int pnlmeas;
double rTimerInterval;
int ret, counter = 0;
ViStatus status;
ViSession ID;

int StartFlag = FALSE;

int main (int argc, char *argv[])
{	 // standard code generated by LabWindows
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((pnlmeas = LoadPanel (0, "Demo1.uir", PNLMEAS)) < 0)
		return -1;
	DisplayPanel (pnlmeas);
	RunUserInterface ();
	DiscardPanel (pnlmeas);
	return 0;
}

int CVICALLBACK ProcessTimer (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{		    ViChar buf[128];
            ViInt32 gMeasType;
            ViReal64 dMeasValue;
            char hold[30];
            int index;
            
			if ((StartFlag == TRUE) && (event == EVENT_TIMER_TICK)){
			      
			      // get index of currently selected item
			      ret = GetCtrlIndex(pnlmeas,PNLMEAS_LSTMEAS, &index);
			      switch(index){
			        case 0:
			           // get measurement value 
			           tktds8k_GetMeasValue (ID, tktds8k_MEAS_1, &dMeasValue);
			           break;
			        case 1:
			           tktds8k_GetMeasValue (ID, tktds8k_MEAS_2, &dMeasValue);   
			           break;
			        case 2 :
			           tktds8k_GetMeasValue (ID, tktds8k_MEAS_3, &dMeasValue);
			           break;
			        case 3 :
			           tktds8k_GetMeasValue (ID, tktds8k_MEAS_4, &dMeasValue);
			           break;
			        case 4 :
			           tktds8k_GetMeasValue (ID, tktds8k_MEAS_5, &dMeasValue);
			           break;
			        case 5 :
			           tktds8k_GetMeasValue (ID, tktds8k_MEAS_6, &dMeasValue);
			           break;
			        case 6 :
			           tktds8k_GetMeasValue (ID, tktds8k_MEAS_7, &dMeasValue);
			           break;
			        case 7 :
			           tktds8k_GetMeasValue (ID, tktds8k_MEAS_8, &dMeasValue);
			           break;
			        default:
			            break;
			      }
			      // format floating point value to 12 levels of precision
                  Fmt(hold,"%s<%f[p12]", dMeasValue);
                  //clear string buffer
                  buf[0] = '\0';
                  strcpy(buf, hold); 
			      // insert into list box
			      ret = InsertListItem (pnlmeas, PNLMEAS_LSTVALUES, -1, buf, index);
			      counter++;
			      // turn off after 1000 acquisitions
			      if(counter >= 1000){
			        StartFlag = FALSE;
			        ret = SetCtrlAttribute(pnlmeas,PNLMEAS_TIMER,ATTR_ENABLED,FALSE);
			        }
			   }
			   else {
			      StartFlag = FALSE;
			    
			   }
		
		return 0;
	
}

int CVICALLBACK cmdStop (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		    // disable timer
		    ret = SetCtrlAttribute(pnlmeas,PNLMEAS_TIMER,ATTR_ENABLED,FALSE);
			StartFlag = FALSE;
			break;
		}
	return 0;
}

int CVICALLBACK cmdExit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			QuitUserInterface (0);
			break;
		}
	return 0;
}

int CVICALLBACK TimerInterval (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		    // read interval from dial control and assign to timer control 
		    ret = GetCtrlVal(pnlmeas, PNLMEAS_TINTERVAL,&rTimerInterval);
		    ret = SetCtrlAttribute(pnlmeas,PNLMEAS_TIMER,ATTR_INTERVAL,rTimerInterval);

			break;
		}
	return 0;
}

int CVICALLBACK cmdSTART (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{   char InstDesc[128];
    char buf[256];
    char *intro = "Connected to: ";
    int n;
    
	switch (event)
		{
		case EVENT_COMMIT:
		    // reset counter variable
		    counter = 0;
		    // indicate to user we are connecting to scope
		    ret = SetCtrlVal(pnlmeas, PNLMEAS_LBLSTATUS, "Connecting to first scope found...");
		    // clear measurement values list box
		    ret = ClearListCtrl(pnlmeas, PNLMEAS_LSTVALUES);
		    // connect
		    status = tktds8k_autoConnectToFirst (&ID);
		    if (status >= VI_SUCCESS)
		      // display instrument description to user once connected
		      ret = tktds8k_GetInstrDesc (ID, InstDesc);
		      buf[0]='\0';
		      strcat(buf, intro);
		      strcat(buf,InstDesc);
		      // enable timer and change StartFlag
		      ret = SetCtrlVal(pnlmeas, PNLMEAS_LBLSTATUS, buf);      
		      ret = SetCtrlAttribute(pnlmeas,PNLMEAS_TIMER,ATTR_ENABLED,TRUE);
			  StartFlag = TRUE;
			break;
		}
	return 0;
}

int CVICALLBACK HandlePanel (int panel, int event, void *callbackData,
		int eventData1, int eventData2)
{   char buf[128];
    char hold[30];
    char *item = "Meas ";
    int i;

	switch (event)
		{
		case EVENT_GOT_FOCUS:
			// clear measurement panel
			ret = ClearListCtrl (pnlmeas, PNLMEAS_LSTMEAS);
		    // populate list box with measurements for TDS/CSA8000 
			for(i = 1; i <= 8; i++){
			   Fmt(hold,"%s<%i", i);
			   buf[0] = '\0';
			   strcat(buf, item);
               strcat(buf, hold);			      
			   ret = InsertListItem (pnlmeas, PNLMEAS_LSTMEAS, -1, buf, counter);
			}
			 // set index value to Meas1
			 ret = SetCtrlIndex(pnlmeas,PNLMEAS_LSTMEAS, 0);  
			break;
		case EVENT_LOST_FOCUS:

			break;
		case EVENT_CLOSE:

			break;
		}
	return 0;
}
